function [] = join_props_db(dir_tmp)
%function for joining properties of subclasses for entry into the
%relational data base.
%Synatax:   [dbdata] = join_props_db();
%Input:     dir_tmp = the directory of interest
%Output:    none
if nargin==0
    dir_tmp = uigetdir2('','Directory where the files are located');    %get the directory
end
%Now sort through the directory and find the
[filenames,names,header] = dir_sort(dir_tmp);

%Now open each file append and save
mkdir(dir_tmp,'dbjoined');
for k = 1:size(filenames,1)
    for j = 1:size(filenames,2) %go through the file sets
        filename_tmp = filenames{k,j};
        data = [];  %initialize/reset
        verti_tmp = [];
        for i = 1:size(filename_tmp,1)      %now append the files
            %verti_tmp{i} = single(dlmread([pathname_tmp,filename_tmp{1,i}],','));
            try     %file could be empty
                verti_tmp = single(dlmread([dir_tmp,filesep,filename_tmp(i,:)],',',1,0));
                data = vertcat(data,verti_tmp);       %join all the opened data together
            end
        end
        if ~isempty(data)   %make sure there is data first
            %now save out the data file
            dataout = dataset(data);
            sav2csv(dataout,[header{k,1},'_',names{j,1},'_',num2str(size(data,1)),'.csv'],[dir_tmp,'\dbjoined']);
        end
    end
end


%-----------------------------------------------------------------------------------------------------------------------------
function [filenames_out,uq_names,uq_header] = dir_sort(dir_tmp)
%give the directory and it will sort out the files in it and put a cell
%array of filenames
dir_struct = dir(dir_tmp);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
names = {dir_struct.name};   %grab the all of the names in the root
filenames = names(~idx);
%filename_tmp = filename_tmp(3:end,:);
for i = 1:size(filenames,2)      %step through each filename and pull the wanted word
    filename_tmp = filenames{i};
    strmask = isstrprop(filename_tmp,'punct');  %find the punctuations, we only want the last two
    strmask2 = filename_tmp=='&';       %we are going to exempt the & character
    strmask3 = isstrprop(filename_tmp,'wspace');    %included the spaces as well
    strmask = strmask-strmask2+strmask3;     %removed and append
    [x,y] = find(strmask==1);  %get the positions
    a = 1;  %initiate
    b = 0;
    tmp = filename_tmp(1,y(end-a)+1:y(end-b)-1);    %create an array of the words
    while ~isempty(str2num(tmp))   %not empty = numbers or vertices file, push forward one and go
        a = a+1;
        b = b+1;
        if size(y,2)-a==0
            break
        end
        tmp = filename_tmp(1,y(end-a)+1:y(end-b)-1);    %create an array of the words
    end
    %now do the same for the front
    a = 0;
    tmp = filename_tmp(1,1:y(1+a)-1);
    while ~isempty(str2num(tmp))&&size(y,2)~=a+1   %not empty = numbers or vertices file, push forward one and go
        a = a+1;
        tmp = filename_tmp(1,1:y(1+a)-1);    %create an array of the words
    end
    if a==0
        f_tmp{i,:} = filename_tmp(1,1:y(end-b)-1);
    else
        f_tmp{i,:} = filename_tmp(1,y(a)+1:y(end-b)-1);
    end
    %all we need is the numbers in front
    h_tmp{i,:} = filename_tmp(1,1:y(1)-1);
end
uq_names = unique(f_tmp);    %how many unique words are there
uq_header = unique(h_tmp);
for l = 1:size(uq_header,1)
    for j = 1:size(uq_names,1)      %step through unique names
        tmp = [];
        for k = 1:size(f_tmp,1)     %step through the all file names
            if strcmpi(uq_names(j,:),f_tmp(k,:))&&strcmpi(uq_header(l,:),h_tmp(k,:)) %if there is a match (case insensitive now)
                tmp = vertcat(tmp,filenames(k));  %put it in the current file names temp
            end
        end
        filenames_out{l,j} = char(tmp);
    end
end